VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} FrmGenerateBulkPayslip 
   Caption         =   "GENERATE BULK PAYSLIP"
   ClientHeight    =   3810
   ClientLeft      =   120
   ClientTop       =   465
   ClientWidth     =   7710
   OleObjectBlob   =   "FrmGenerateBulkPayslip.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "FrmGenerateBulkPayslip"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False


Public Function GetEmployeeName(empID As String) As String
    Dim ws As Worksheet
    Dim r As Long, lastRow As Long
    
    Set ws = Sheets(EMP_SHEET)
    lastRow = ws.Cells(ws.Rows.Count, "A").End(xlUp).Row
    
    For r = 2 To lastRow
        If ws.Cells(r, 1).Value = empID Then
            GetEmployeeName = ws.Cells(r, 2).Value
            Exit Function
        End If
    Next r
    
    GetEmployeeName = ""
End Function



Public Function GetDepartment(empID As String) As String
    Dim ws As Worksheet
    Dim r As Long, lastRow As Long
    
    Set ws = Sheets(EMP_SHEET)
    lastRow = ws.Cells(ws.Rows.Count, "A").End(xlUp).Row
    
    For r = 2 To lastRow
        If ws.Cells(r, 1).Value = empID Then
            GetDepartment = ws.Cells(r, 4).Value
            Exit Function
        End If
    Next r
    
    GetDepartment = ""
End Function


Private Sub cmdBrowse_Click()

    Dim fldr As FileDialog
    Dim folderPath As String
    
    Set fldr = Application.FileDialog(msoFileDialogFolderPicker)
    
    With fldr
        .Title = "Select Folder To Save Payslips"
        .AllowMultiSelect = False
        
        If .Show <> -1 Then Exit Sub
        
        folderPath = .SelectedItems(1)
    End With
    
    txtFpath.Text = folderPath

End Sub


Private Sub cmdGenerate_Click()

    Dim payMonth As Date
    Dim ws As Worksheet
    Dim lastRow As Long, r As Long
    Dim empID As String
    Dim v, rowMonth As Date
    Dim saveFolder As String
    Dim slipWS As Worksheet
    Dim empWS As Worksheet
    Dim foundAny As Boolean
    
    If txtMonth.Value = "" Then
        MsgBox "Enter payroll month", vbExclamation
        Exit Sub
    End If
    
    If txtFpath.Value = "" Then
        MsgBox "Select folder path", vbExclamation
        Exit Sub
    End If
    
    saveFolder = txtFpath.Value
    
    ' Validate month input
    On Error Resume Next
    If IsDate(txtMonth.Value) Then
        payMonth = DateSerial(Year(CDate(txtMonth.Value)), Month(CDate(txtMonth.Value)), 1)
    Else
        payMonth = DateValue("01-" & txtMonth.Value)
    End If
    
    If Err.Number <> 0 Then
        MsgBox "Invalid Month Format. Try: Jan-2025", vbCritical
        Exit Sub
    End If
    On Error GoTo 0
    
    Set ws = Sheets(PAY_SHEET)
    Set slipWS = Sheets(SLIP_SHEET)
    Set empWS = Sheets(EMP_SHEET)
    
    lastRow = ws.Cells(ws.Rows.Count, "A").End(xlUp).Row
    foundAny = False
    
    For r = 2 To lastRow
        
        v = ws.Cells(r, 2).Value
        
        If v <> "" Then
        
            ' Convert payroll month safely
            If IsDate(v) Then
                rowMonth = DateSerial(Year(v), Month(v), 1)
            Else
                rowMonth = DateValue("01-" & v)
            End If
            
            ' Month Match
            If Month(rowMonth) = Month(payMonth) And _
               Year(rowMonth) = Year(payMonth) Then
            
                empID = ws.Cells(r, 3).Value
                foundAny = True
                
                '======== Fill PAYSLIP Sheet =========
                slipWS.Range("C4").Value = GetEmployeeName(empID)
                slipWS.Range("C5").Value = empID
                slipWS.Range("E4").Value = GetDepartment(empID)
                slipWS.Range("E5").Value = ws.Cells(r, 2).Value
                
                slipWS.Range("D9").Value = ws.Cells(r, 4).Value
                slipWS.Range("D11").Value = ws.Cells(r, 5).Value
                slipWS.Range("D13").Value = ws.Cells(r, 6).Value
                slipWS.Range("D15").Value = ws.Cells(r, 9).Value
                slipWS.Range("D17").Value = ws.Cells(r, 7).Value
                slipWS.Range("D19").Value = ws.Cells(r, 8).Value
                slipWS.Range("D21").Value = ws.Cells(r, 10).Value
                
                slipWS.Range("D24").Value = ws.Cells(r, 11).Value
                slipWS.Range("D26").Value = ws.Cells(r, 13).Value
                slipWS.Range("D28").Value = "HR / Accounts Officer"
                
                '======== SAVE PDF =========
                Dim fileName As String
                fileName = empID & "_" & ws.Cells(r, 2).Text & "_Payslip.pdf"
                
                If Right(saveFolder, 1) <> "\" Then saveFolder = saveFolder & "\"
                
                slipWS.ExportAsFixedFormat _
                    Type:=xlTypePDF, _
                    fileName:=saveFolder & fileName, _
                    Quality:=xlQualityStandard, _
                    IncludeDocProperties:=True, _
                    IgnorePrintAreas:=False, _
                    OpenAfterPublish:=False
            End If
        End If
    
    Next r
    
    If foundAny Then
        MsgBox "All Payslips Generated Successfully!", vbInformation
    Else
        MsgBox "No payroll records found for selected month", vbExclamation
    End If

End Sub

Private Sub UserForm_Click()

End Sub
